<?php

namespace Drupal\state_machine_test\Guard;

use Drupal\state_machine\Guard\GuardInterface;
use Drupal\state_machine\Plugin\Workflow\WorkflowInterface;
use Drupal\state_machine\Plugin\Workflow\WorkflowTransition;
use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Session\AccountInterface;

class GenericGuard implements GuardInterface {

  /**
   * The current user.
   *
   * @var \Drupal\Core\Session\AccountInterface
   */
  protected $currentUser;

  /**
   * Constructs a new GenericGuard object.
   *
   * @param \Drupal\Core\Session\AccountInterface $current_user
   *   The current user.
   */
  public function __construct(AccountInterface $current_user) {
    $this->currentUser = $current_user;
  }

  /**
   * {@inheritdoc}
   */
  public function allowed(WorkflowTransition $transition, WorkflowInterface $workflow, EntityInterface $entity) {
    // Only a "supervisor" user can cancel an entity in validation.
    if ($transition->getId() == 'cancel' && $entity->field_state->first()->value == 'validation') {
      return (bool) array_intersect(['merchant'], $this->currentUser->getRoles());
    }
  }

}
